// Preferences Manager
//
// this script for exporting and importing preference settings of hotkeys or layout.
//
// tested with only v.4.2.

var fileExt = 'c3dsettings';
var appDomain = "de.wengenmayer.Cheetah3D";
var keys = new Array("MWMKeyboard", "MWMLayout4"); // 6.3+  - new Array("MWMHotKeys2","MWMLayout4");
var checkPats = new Array(new RegExp(/commands/), new RegExp(/winLayout[a-zA-z1-4]+/)); // very very very easy check. :p

function buildUI(tool) {
	tool.addParameterSeparator("Preferences Manager");

	tool.addParameterSelector("Pref Name",["Hotkey","Layout"],true,true);

	tool.addParameterButton("Export","Export","exportDefaults");
	tool.addParameterButton("Import","Import","importDefaults");
}

function exportDefaults(tool) {
    var mode = parseInt(tool.getParameter("Pref Name"));
    var doc = tool.document();
    
    var path = OS.runSavePanel(fileExt); // selecting file for saving.
    if (path == null) {
        return;
    }
    
    OS.system("defaults read "+appDomain+" "+keys[mode]+" > "+path);
}

function importDefaults(tool) {
    var mode = parseInt(tool.getParameter("Pref Name"));
    var doc = tool.document();
    
    var path = OS.runOpenPanel(fileExt);
    if (path == null) {
        return;
    }
    
    var file = new File(path);
    file.open(READ_MODE);
    if (file.isOpen() == false) {
        return;
    }
    
    // prepare data from file.
    var pat = new RegExp(/(.+)/); // remove newline pattern.
    var checkPat = checkPats[mode]; // checking pattern.
    var patChecked = false;
    
    var line = file.readln();
    var values = '';
    var res = null;
    while (line.match) {
        res = line.match(pat);
        if (line.match(checkPat)) patChecked = true;
        if (res) {
            values += res[1].replace(/\\U/g, "\U");
        }
        line = file.readln();
    }
    
    if (patChecked) {
        OS.messageBox("This operation is NOT undonable. Do you want to overwrite preferences settings?"," Before executing this operation, I recommend taking backup for "+appDomain+".plist file in ~/Library/Preferences folder.");
        OS.system("defaults write "+appDomain+" "+keys[mode]+" '"+values+"'");
    } else {
        OS.messageBox("Selected file seems to be WRONG!","This operation is cancelled.");
    }
}